/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.entity.EntityLiving;
import net.jayjay.dangerzone.entity.model.ModelBiped;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityZombie
extends EntityLiving {
    public float rot;
    public float timeOffs;
    public float speed;
    public float rotA = (float)(Math.random() + 1.0) * 0.01f;
    private static ModelBiped zombieModel = new ModelBiped();

    public EntityZombie(World level, float x, float y, float z) {
        super(level);
        this.texture = "/char.png";
        this.setSize(0.8f, 1.6f);
        this.setHealth(50);
        this.setPos(x, y, z);
        this.timeOffs = (float)Math.random() * 1239813.0f;
        this.rot = (float)(Math.random() * Math.PI * 2.0);
        this.speed = 1.0f;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.health < 0) {
            this.health = 0;
        }
        if (this.isDead()) {
            this.remove();
        }
        float xa = 0.0f;
        float ya = 0.0f;
        if (this.y < -100.0f) {
            this.remove();
        }
        this.rot += this.rotA;
        this.rotA = (float)((double)this.rotA * 0.99);
        this.rotA = (float)((double)this.rotA + (Math.random() - Math.random()) * Math.random() * Math.random() * (double)0.08f);
        xa = (float)Math.sin(this.rot);
        ya = (float)Math.cos(this.rot);
        if (this.onGround && Math.random() < 0.08) {
            this.yd = 0.5f;
        }
        this.moveRelative(xa, ya, this.onGround ? 0.1f : 0.02f);
        this.yd = (float)((double)this.yd - 0.08);
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.91f;
        this.yd *= 0.98f;
        this.zd *= 0.91f;
        if (this.onGround) {
            this.xd *= 0.7f;
            this.zd *= 0.7f;
        }
    }

    @Override
    public void render(float a2) {
        GL11.glEnable(3553);
        Textures.bindNearest(this.texture);
        GL11.glPushMatrix();
        double time = (double)System.nanoTime() / 1.0E9 * 10.0 * (double)this.speed + (double)this.timeOffs;
        float size = 0.058333334f;
        float yy = (float)(-Math.abs(Math.sin(time * 0.6662)) * 5.0 - 23.0);
        GL11.glTranslatef(this.xo + (this.x - this.xo) * a2, this.yo + (this.y - this.yo) * a2, this.zo + (this.z - this.zo) * a2);
        GL11.glScalef(1.0f, -1.0f, 1.0f);
        GL11.glScalef(size, size, size);
        GL11.glTranslatef(0.0f, yy, 0.0f);
        float c2 = 57.29578f;
        GL11.glRotatef(this.rot * c2 + 180.0f, 0.0f, 1.0f, 0.0f);
        zombieModel.render((float)time);
        GL11.glPopMatrix();
        GL11.glDisable(3553);
    }
}

